/**
 * Enhancements for Ext.data.Connection:
 * 
 * Inject the session automatically on each request if a
 * session is available.
 */
Ext.override(Ext.data.Connection, {
	/**
	 * Inject session header. I haven't found a better way to do
	 * it :(
	 */
	setupHeaders: function (xhr, options, data, params) {
		var session;
		
		if (!options.headers) {
			options.headers = {};
		}
		
		if (PartKeepr.getApplication() !== null) {
			session = PartKeepr.getApplication().getSession();
			if (session !== null) {
				options.headers.session = session;
			}
		}
		
		var headers = this.callOverridden(arguments);
		
		return headers;
	}

});